#!/usr/bin/env python3
"""
Configuración para hosting con Python
"""

# Configuración de la aplicación
DEBUG = False
SECRET_KEY = 'tu-clave-secreta-aqui'

# Configuración de base de datos (si necesitas)
# DATABASE_URL = 'sqlite:///app.db'

# Configuración de archivos estáticos
STATIC_FOLDER = 'static'
TEMPLATE_FOLDER = 'templates'

# Configuración de logging
LOG_LEVEL = 'INFO'

# Configuración de OpenCV para hosting
CV2_OPTIMIZATION = {
    'resize_max_width': 600,
    'jpeg_quality': 80,
    'kernel_size': 3
}

# Configuración de detección
DETECTION_CONFIG = {
    'min_area': 300,
    'confidence_threshold': 0.3,
    'aspect_ratio_min': 0.3,
    'aspect_ratio_max': 3.0
}
