# 🚀 Guía de Despliegue en Hosting con Python

## 📋 **PASOS PARA DESPLEGAR EN TU HOSTING**

### **1. Preparar los Archivos**

Sube estos archivos a tu hosting:
```
📁 public_html/chalecos/
├── app_hosting.py          # Aplicación principal
├── wsgi.py                 # Configuración WSGI
├── requirements_hosting.txt # Dependencias
├── config_hosting.py      # Configuración
├── .htaccess              # Configuración Apache
└── templates/
    └── index.html         # Interfaz web
```

### **2. Configurar Python en cPanel**

#### **A. Crear Entorno Virtual**
1. Ve a **"Python App"** en cPanel
2. Haz clic en **"Create Application"**
3. Configura:
   - **App Name**: `chalecos-detection`
   - **Python Version**: `3.9` o superior
   - **App Directory**: `chalecos`

#### **B. Instalar Dependencias**
```bash
# En la terminal de cPanel o SSH
cd chalecos
pip install -r requirements_hosting.txt
```

### **3. Configurar la Aplicación**

#### **A. Archivo WSGI**
El archivo `wsgi.py` ya está configurado correctamente.

#### **B. Archivo .htaccess**
El archivo `.htaccess` redirige todas las peticiones a tu aplicación Python.

### **4. Activar la Aplicación**

1. En **"Python App"** de cPanel
2. Haz clic en **"Start"** en tu aplicación
3. Verifica que esté **"Running"**

### **5. Configurar Dominio**

#### **Opción A: Subdominio**
- Crea un subdominio: `chalecos.tudominio.com`
- Apunta a la carpeta `chalecos`

#### **Opción B: Subcarpeta**
- Accede desde: `tudominio.com/chalecos`

### **6. Verificar Funcionamiento**

Visita tu aplicación:
- **URL**: `https://tudominio.com/chalecos`
- **Health Check**: `https://tudominio.com/chalecos/health`

---

## 🔧 **CONFIGURACIÓN AVANZADA**

### **A. Variables de Entorno**
En cPanel, ve a **"Environment Variables"** y agrega:
```
FLASK_ENV=production
PYTHONPATH=/home/usuario/chalecos
```

### **B. Configurar SSL**
1. Ve a **"SSL/TLS"** en cPanel
2. Activa **"Force HTTPS Redirect"**
3. Configura certificado SSL

### **C. Optimizar Rendimiento**
1. **Compresión**: Activa gzip en cPanel
2. **Caché**: Configura headers de caché
3. **CDN**: Usa Cloudflare si es posible

---

## 🎯 **ESTRUCTURA FINAL EN TU HOSTING**

```
📁 public_html/
├── 📁 chalecos/                    # Tu aplicación
│   ├── app_hosting.py              # ✅ Aplicación principal
│   ├── wsgi.py                     # ✅ Configuración WSGI
│   ├── requirements_hosting.txt    # ✅ Dependencias
│   ├── config_hosting.py          # ✅ Configuración
│   ├── .htaccess                  # ✅ Redirección
│   └── 📁 templates/
│       └── index.html             # ✅ Interfaz web
└── 📁 otros-sitios/               # Otros sitios web
```

---

## 🚀 **COMANDOS ÚTILES**

### **Reiniciar Aplicación**
```bash
# En cPanel Python App
# Haz clic en "Restart"
```

### **Ver Logs**
```bash
# En cPanel, ve a "Logs"
# Revisa "Error Logs" y "Access Logs"
```

### **Actualizar Código**
```bash
# Sube los archivos nuevos
# Reinicia la aplicación
```

---

## 🎮 **CÓMO USAR TU APP**

1. **Abre**: `https://tudominio.com/chalecos`
2. **Permite acceso a la cámara**
3. **Haz clic en "Iniciar Cámara"**
4. **Posiciónate frente a la cámara**
5. **Haz clic en "Capturar y Detectar"**
6. **¡Ve los resultados!**

---

## 🔍 **SOLUCIÓN DE PROBLEMAS**

### **Error: "Module not found"**
```bash
# Instala dependencias manualmente
pip install Flask opencv-python-headless Pillow numpy
```

### **Error: "Permission denied"**
```bash
# Verifica permisos de archivos
chmod 755 app_hosting.py
chmod 755 wsgi.py
```

### **Error: "Application not running"**
1. Ve a **"Python App"** en cPanel
2. Verifica que esté **"Running"**
3. Revisa los logs de error

### **Error: "500 Internal Server Error"**
1. Revisa **"Error Logs"** en cPanel
2. Verifica que todas las dependencias estén instaladas
3. Comprueba la sintaxis de los archivos Python

---

## 📊 **VENTAJAS DEL HOSTING**

✅ **Control total** sobre tu aplicación
✅ **Sin límites** de tamaño
✅ **Costo fijo** mensual
✅ **Acceso SSH** (si está disponible)
✅ **Bases de datos** incluidas
✅ **SSL gratuito** con Let's Encrypt
✅ **Backups automáticos**

---

## 🎯 **PRÓXIMOS PASOS**

1. **Sube los archivos** a tu hosting
2. **Configura Python** en cPanel
3. **Instala dependencias**
4. **Activa la aplicación**
5. **Prueba la funcionalidad**
6. **¡Comparte tu app!**

---

**¡Tu aplicación de detección de chalecos estará funcionando en tu propio hosting! 🌐🎉**
